package com.bycom.versapro.Utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import com.bycom.versapro.R;

public class CustomProgressBar extends View {

    private int progress = 0;
    private Paint backgroundPaint;
    private Paint progressPaint;

    public CustomProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPaint();
    }

    public void setForegroundColor(int color) {
        progressPaint.setColor(color);
        invalidate();
    }

    private void initPaint() {
        backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.GRAY);
        backgroundPaint.setStyle(Paint.Style.FILL);

        progressPaint = new Paint();
        progressPaint.setColor(getResources().getColor(R.color.toolbar_content,null));
        progressPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0, 0, getWidth(), getHeight(), backgroundPaint);
        int progressWidth = (int) ((float) getWidth() * progress / 100);
        canvas.drawRect(0, 0, progressWidth, getHeight(), progressPaint);
    }

    public void setProgress(int progress) {
        this.progress = progress;
        invalidate();
    }
}
